<?php
/**
 * Plugin Name: Pro AMP AdSense Manager
 * Description: AMP uyumlu, yerleşim kontrollü AdSense reklam yöneticisi. Kısa kod, widget ve içerik içine otomatik ekleme desteği.
 * Version: 1.0.0
 * Author: wordpresseklenti.shop
 * Plugin URI: https://wordpresseklenti.shop/
 * Author URI: https://wordpresseklenti.shop/
 * Text Domain: pro-amp-adsense
 * Domain Path: /languages
 * Requires at least: 5.5
 * Requires PHP: 7.4
 */

if ( ! defined( 'ABSPATH' ) ) { exit; }

define( 'PAAM_VERSION', '1.0.0' );
define( 'PAAM_FILE', __FILE__ );
define( 'PAAM_DIR', plugin_dir_path( __FILE__ ) );
define( 'PAAM_URL', plugin_dir_url( __FILE__ ) );

require_once PAAM_DIR . 'includes/class-settings.php';
require_once PAAM_DIR . 'includes/class-renderer.php';
require_once PAAM_DIR . 'includes/class-inserter.php';
require_once PAAM_DIR . 'includes/class-widget.php';

class PAAM_Bootstrap {
	public function __construct() {
		add_action( 'plugins_loaded', [ $this, 'i18n' ] );
		add_action( 'init', [ $this, 'init' ] );
		register_activation_hook( __FILE__, [ $this, 'activate' ] );
		register_uninstall_hook( __FILE__, [ 'PAAM_Bootstrap', 'uninstall' ] );
	}

	public function i18n() {
		load_plugin_textdomain( 'pro-amp-adsense', false, dirname( plugin_basename( __FILE__ ) ) . '/languages' );
	}

	public function init() {
		new PAAM_Settings();
		new PAAM_Renderer();
		new PAAM_Inserter();
		new PAAM_Widget();
		add_shortcode( 'paam_ad', [ 'PAAM_Renderer', 'shortcode' ] );
	}

	public function activate() {
		$defaults = [
			'publisher_id' => '',
			'placements'   => [
				'header'         => ['enabled' => 0],
				'before_content' => ['enabled' => 0],
				'after_content'  => ['enabled' => 1],
				'in_content'     => ['enabled' => 1, 'paragraph' => 2],
				'sticky'         => ['enabled' => 0],
			],
			'non_amp' => [
				'header_code'         => '',
				'before_content_code' => '',
				'after_content_code'  => '',
				'in_content_code'     => '',
			],
			'amp' => [
				'header_slot'         => '',
				'in_article_slot'     => '',
				'after_content_slot'  => '',
				'sticky_slot'         => '',
				'width'               => 336,
				'height'              => 280,
			],
			'post_types' => ['post' => 1, 'page' => 0],
			'excluded_categories' => [],
			'consent_required' => 0,
		];
		add_option( 'paam_options', $defaults );
	}

	public static function uninstall() {
		delete_option( 'paam_options' );
	}
}

new PAAM_Bootstrap();
