<?php
if ( ! defined( 'ABSPATH' ) ) { exit; }

class PAAM_Widget extends WP_Widget {

	public function __construct() {
		parent::__construct(
			'paam_widget',
			__('Pro AMP AdSense Widget', 'pro-amp-adsense'),
			[ 'description' => __('AMP uyumlu reklam widget\'ı', 'pro-amp-adsense') ]
		);
		add_action( 'widgets_init', function(){ register_widget( 'PAAM_Widget' ); } );
	}

	public function widget( $args, $instance ) {
		echo $args['before_widget'];
		if ( ! empty( $instance['title'] ) ) {
			echo $args['before_title'] . apply_filters( 'widget_title', $instance['title'] ) . $args['after_title'];
		}
		echo '<div class="paam-widget-ad" style="text-align:center">';
		echo PAAM_Renderer::render_place( 'after_content' );
		echo '</div>';
		echo $args['after_widget'];
	}

	public function form( $instance ) {
		$title = isset( $instance['title'] ) ? $instance['title'] : __( 'Reklam', 'pro-amp-adsense' );
		?>
		<p>
			<label for="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>"><?php _e( 'Başlık:' ); ?></label> 
			<input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'title' ) ); ?>" type="text" value="<?php echo esc_attr( $title ); ?>">
		</p>
		<p class="description">Widget, eklenti ayarlarındaki <strong>İçerikten Sonra</strong> konfigürasyonunu kullanır.</p>
		<?php 
	}

	public function update( $new_instance, $old_instance ) {
		$instance = [];
		$instance['title'] = ( ! empty( $new_instance['title'] ) ) ? sanitize_text_field( $new_instance['title'] ) : '';
		return $instance;
	}
}
