<?php
if ( ! defined( 'ABSPATH' ) ) { exit; }

class PAAM_Renderer {

	public function __construct() {
		add_action( 'wp_head', [ $this, 'enqueue_non_amp_head' ] );
		add_action( 'wp', [ $this, 'amp_component_support' ] );
	}

	public static function is_amp() {
		return function_exists('is_amp_endpoint') && is_amp_endpoint();
	}

	public function enqueue_non_amp_head() {
		if ( self::is_amp() ) return;
		$opts = get_option('paam_options', []);
		// AdSense ana scriptini bir kez yükle
		echo "<!-- Pro AMP AdSense Manager -->\n";
		echo "<script async src=\"https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js?client=" . esc_attr($opts['publisher_id'] ?? '') . "\" crossorigin=\"anonymous\"></script>\n";
		echo "<!-- /Pro AMP AdSense Manager -->\n";
	}

	public function amp_component_support() {
		if ( ! self::is_amp() ) return;
		// AMP şablonuna amp-ad ve amp-sticky-ad scriptlerini ekle
		add_filter( 'amp_post_template_data', function( $data ) {
			if ( empty( $data['amp_component_scripts']['amp-ad'] ) ) {
				$data['amp_component_scripts']['amp-ad'] = 'https://cdn.ampproject.org/v0/amp-ad-0.1.js';
			}
			if ( empty( $data['amp_component_scripts']['amp-sticky-ad'] ) ) {
				$data['amp_component_scripts']['amp-sticky-ad'] = 'https://cdn.ampproject.org/v0/amp-sticky-ad-1.0.js';
			}
			return $data;
		});
	}

	public static function shortcode( $atts = [] ) {
		$atts = shortcode_atts( ['place' => 'after_content'], $atts, 'paam_ad' );
		return self::render_place( $atts['place'] );
	}

	public static function render_place( $place ) {
		$opts = get_option('paam_options', []);
		if ( empty( $opts['placements'][$place]['enabled'] ) ) return '';

		// Kategori/Post type filtreleri
		if ( is_singular() ) {
			$post = get_post();
			$pt_allowed = ! empty( $opts['post_types'][ $post->post_type ] );
			if ( ! $pt_allowed ) return '';
			$exc = $opts['excluded_categories'] ?? [];
			if ( $post->post_type === 'post' && ! empty( $exc ) ) {
				$cats = wp_get_post_categories( $post->ID );
				if ( array_intersect( $exc, $cats ) ) return '';
			}
		}

		// Consent kontrol
		if ( ! empty( $opts['consent_required'] ) ) {
			// Basit bir kontrol: gtag consent granted değişkenine bakmak için data attribute ile beklet
			ob_start(); ?>
			<div class="paam-consent-guard" data-place="<?php echo esc_attr($place); ?>" style="display:block">
				<script>
				(function(){
					function showAd(){var c=document.currentScript.parentNode; if(!c) return; c.innerHTML = <?php echo json_encode( self::raw_ad_markup($place, $opts) ); ?>;}
					// Eğer consent mode varsa ve 'ad_storage' granted ise hemen göster
					try{
						if (window.gtag && window.gtag.get && window.gtag.get('consent','ad_storage') === 'granted') { showAd(); return; }
					}catch(e){}
					// 2. yol: TCF olayını dinle (varsayılan CMP entegrasyonu ile)
					if (window.__tcfapi) {
						window.__tcfapi('addEventListener', 2, function(tcData){
							if(tcData && tcData.eventStatus === 'tcloaded' || tcData.eventStatus === 'useractioncomplete'){ showAd(); }
						});
						return;
					}
					// fallback: zaman aşımı sonra yine de render etme (kullanıcı onayı bekleniyor)
				})();
				</script>
			</div>
			<?php
			return ob_get_clean();
		}

		// Consent gerekmiyorsa direkt göster
		return self::raw_ad_markup($place, $opts);
	}

	private static function raw_ad_markup( $place, $opts ) {
		if ( self::is_amp() ) {
			// AMP markup
			$pub = esc_attr($opts['publisher_id'] ?? '');
			$w   = (int)($opts['amp']['width'] ?? 336);
			$h   = (int)($opts['amp']['height'] ?? 280);
			$slot_key = [
				'header'         => 'header_slot',
				'before_content' => 'in_article_slot',
				'in_content'     => 'in_article_slot',
				'after_content'  => 'after_content_slot',
				'sticky'         => 'sticky_slot',
			];
			$slot = isset($slot_key[$place]) ? esc_attr( $opts['amp'][$slot_key[$place]] ?? '' ) : '';
			if ( empty($slot) || empty($pub) ) return '';

			ob_start();
			if ( $place === 'sticky' ) : ?>
				<amp-sticky-ad layout="nodisplay">
					<amp-ad width="<?php echo (int)$w; ?>" height="<?php echo (int)$h; ?>" type="adsense"
						data-ad-client="<?php echo $pub; ?>"
						data-ad-slot="<?php echo $slot; ?>">
					</amp-ad>
				</amp-sticky-ad>
			<?php else : ?>
				<amp-ad width="<?php echo (int)$w; ?>" height="<?php echo (int)$h; ?>" type="adsense"
					data-ad-client="<?php echo $pub; ?>"
					data-ad-slot="<?php echo $slot; ?>"
					data-full-width>
					<div overflow></div>
				</amp-ad>
			<?php endif;
			return ob_get_clean();
		} else {
			// Non-AMP: tam kod alanlarını kullan
			$key_map = [
				'header'         => 'header_code',
				'before_content' => 'before_content_code',
				'in_content'     => 'in_content_code',
				'after_content'  => 'after_content_code',
				'sticky'         => 'after_content_code', // sticky için ayrı kod girilmediyse birini kullan
			];
			$key = isset($key_map[$place]) ? $key_map[$place] : 'after_content_code';
			$code = $opts['non_amp'][$key] ?? '';
			return $code;
		}
	}
}
