<?php
if ( ! defined( 'ABSPATH' ) ) { exit; }

class PAAM_Inserter {
	public function __construct() {
		add_filter( 'the_content', [ $this, 'inject_content_ads' ] );
		add_action( 'wp_body_open', [ $this, 'header_output' ] );
		add_action( 'wp_footer', [ $this, 'sticky_output' ] );
	}

	public function header_output() {
		$opts = get_option('paam_options', []);
		if ( ! empty($opts['placements']['header']['enabled']) ) {
			echo '<div class="paam-header-ad" style="margin:12px auto; text-align:center;">' . PAAM_Renderer::render_place('header') . '</div>';
		}
	}

	public function sticky_output() {
		$opts = get_option('paam_options', []);
		if ( ! empty($opts['placements']['sticky']['enabled']) ) {
			echo PAAM_Renderer::render_place('sticky');
		}
	}

	public function inject_content_ads( $content ) {
		if ( ! is_singular() || ! in_the_loop() || ! is_main_query() ) return $content;

		$opts = get_option('paam_options', []);
		$before = $after = $in = '';

		if ( ! empty($opts['placements']['before_content']['enabled']) ) {
			$before = '<div class="paam-before-content" style="margin:12px 0;text-align:center;">' . PAAM_Renderer::render_place('before_content') . '</div>';
		}

		if ( ! empty($opts['placements']['after_content']['enabled']) ) {
			$after = '<div class="paam-after-content" style="margin:12px 0;text-align:center;">' . PAAM_Renderer::render_place('after_content') . '</div>';
		}

		if ( ! empty($opts['placements']['in_content']['enabled']) ) {
			$paragraph = max(1, (int)($opts['placements']['in_content']['paragraph'] ?? 2));
			$in_markup = '<div class="paam-in-content" style="margin:12px 0;text-align:center;">' . PAAM_Renderer::render_place('in_content') . '</div>';
			$content = $this->insert_after_paragraph( $in_markup, $paragraph, $content );
		}

		return $before . $content . $after;
	}

	private function insert_after_paragraph( $insertion, $paragraph_id, $content ) {
		$closing_p = '</p>';
		$paragraphs = explode( $closing_p, $content );
		foreach ( $paragraphs as $index => $paragraph ) {
			if ( trim($paragraph) ) {
				$paragraphs[$index] .= $closing_p;
			}
			if ( $paragraph_id == $index + 1 ) {
				$paragraphs[$index] .= $insertion;
			}
		}
		return implode( '', $paragraphs );
	}
}
